/**
 * 
 */
package gov.va.genisis2.bo;

import gov.va.genisis2.dto.AttachmentDTO;
import gov.va.genisis2.dto.CommentHistoryDTO;
import gov.va.genisis2.dto.RequestDTO;
import gov.va.genisis2.dto.StudyApprovalDTO;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;
import gov.va.genisis2.vo.CopyTableSource;

import org.springframework.web.multipart.MultipartFile;

/**
 * @author 586338
 *
 */
public interface IBusiness {
	public ResponseWrapper getGenisisAPIDetails() throws GenisisServiceException;

	// Study Approval
	public ResponseWrapper createStudyApproval(StudyApprovalDTO studyApprovalDto) throws GenisisServiceException;

	public ResponseWrapper getStudyApprovalsByID(int id) throws GenisisServiceException;

	public ResponseWrapper getStudyApprovalsByUID(String uid) throws GenisisServiceException;

	public ResponseWrapper getStudyApprovals() throws GenisisServiceException;

	public ResponseWrapper updateStudyApproval(StudyApprovalDTO studyApprovalDto) throws GenisisServiceException;

	// Researcher Requests
	public ResponseWrapper getRequestDataSources() throws GenisisServiceException;

	public ResponseWrapper createRequest(RequestDTO requestDto) throws GenisisServiceException;

	public ResponseWrapper getRequestTypes() throws GenisisServiceException;

	public ResponseWrapper getRequestByID(int id) throws GenisisServiceException;

	public ResponseWrapper getRequestTrackingByID(int id, String userRole) throws GenisisServiceException;

	public ResponseWrapper getRequestsByDataManagers(String uid) throws GenisisServiceException;

	public ResponseWrapper getRequestsDataSourceManagers(String uid) throws GenisisServiceException;

	public ResponseWrapper getRequestsByUID(String uid) throws GenisisServiceException;

	public ResponseWrapper getAllRequests() throws GenisisServiceException;

	public ResponseWrapper getAllRequestsByStudyApproval(int studyApprovalId) throws GenisisServiceException;

	public ResponseWrapper getAllRequestsByStaus(String status) throws GenisisServiceException;

	public ResponseWrapper submitOrModify(RequestDTO requestDto) throws GenisisServiceException;

	public ResponseWrapper persist(int id, RequestDTO changeRequest, String operation) throws GenisisServiceException;

	// Comments
	public ResponseWrapper createCommentHistory(CommentHistoryDTO commentHistoryDto) throws GenisisServiceException;

	public ResponseWrapper acceptFileAttachment(AttachmentDTO attachmentDTO) throws GenisisServiceException;

	// Copy Table
	public ResponseWrapper getCopyTableDomainDetails() throws GenisisServiceException;

	public ResponseWrapper performTableCopyTransfer(CopyTableSource copyTableSource, int requestId) throws GenisisServiceException;

	// User Management
	public ResponseWrapper getUserRole(int uid) throws GenisisServiceException;

	public ResponseWrapper getUserDetailsByEmail(String email) throws GenisisServiceException;

	public ResponseWrapper getUserDetailsById(int id) throws GenisisServiceException;

	public ResponseWrapper getUserDetailsByUsername(String username) throws GenisisServiceException;

	public ResponseWrapper getUserCountsAndLdapLastRefresh() throws GenisisServiceException;

	public ResponseWrapper refreshUserData(String username) throws GenisisServiceException;

	// Request Status Counts
	public ResponseWrapper getRequestStatusCounts() throws GenisisServiceException;

	ResponseWrapper uploadFileAttachment(String jsonString, MultipartFile file) throws GenisisServiceException;

	public ResponseWrapper getDataTypes() throws GenisisServiceException;

	public ResponseWrapper getRequestTypesByRoles(String username) throws GenisisServiceException;

	public ResponseWrapper getStudyApprovalsByRole(String username) throws GenisisServiceException;

	public ResponseWrapper getTooltipDescription(String fieldName) throws GenisisServiceException;

	public ResponseWrapper getStudyApprovalLdapLastRefresh() throws GenisisServiceException;

	public ResponseWrapper refreshLdapStudyApprovalData(String username) throws GenisisServiceException;
}
